<?php

/**
 * ===========================================================================
 *     ___________
 *    < IntecHost >
 *     -----------
 *            \   ^__^
 *             \  (oo)\_______
 *                (__)\       )\/\
 *                    ||----w |
 *                    ||     ||
 *
 * ===========================================================================
 *                www.IntecHost.com
 * ===========================================================================
 *
 * Project    : IntecHost Live WHMCS API
 * File       : PHP
 * Author     : IntecHost - www.IntecHost.com
 * Created on : 06 June 2025
 * Description: Real-time API for fetching WHMCS product prices, descriptions, and currency exchange rates. Seamlessly integrate dynamic hosting details into your platform.
 * Version    : 1.0.0
 *
 * Notes:
 * - This API returns JSON responses from WHMCS databases.
 * - Use with proper authentication.
 * 
 * Don't Forget enable `GetProducts` Module from WHMCS API
 *
 * ===========================================================================
 */

$folderPath = "json";

if (!is_dir($folderPath)) {
    mkdir($folderPath, 0755, true);
}

$api_url = "https://whmcs_domain/includes/api.php"; // Your WHMCS URL END POINT
$api_id = "xxxxxxxx"; // Your WHMCS API Id Code
$api_secret = "xxxxxxxx"; // Your WHMCS Api Secret Code

// Hosting Fetch
$host_url = 'https://api.intechost.com/main/whmcs_related_tools_internal/whmcs_live_api/whmcs_live_api_hosting.php?api_url=' . $api_url . '&id=' . $api_id . '&secret=' . $api_secret . '';
$host_response = file_get_contents($host_url);

// Domain Fetch
$domain_url = 'https://api.intechost.com/main/whmcs_related_tools_internal/whmcs_live_api/whmcs_live_api_domain.php?api_url=' . $api_url . '&id=' . $api_id . '&secret=' . $api_secret . '';
$domain_response = file_get_contents($domain_url);

file_put_contents('json/host.json', $host_response);
file_put_contents('json/domain.json', $domain_response);

echo "Data saved to JSON";
?>
